/* menu.h */

/******************************************************************************/
/* structures                                                                 */
/******************************************************************************/

typedef struct _menuitem {
	int			x;
	int			y;
	char *			text;
	char			key;
	int			(*func)( void * data );
	void *			funcdata;
	struct _menuitem *	prev;
	struct _menuitem *	next;
} Menuitem;

typedef struct _menu {
	WINDOW *	w;
	Menuitem *	cur_mi;
	void		(*updfunc)(void);
} Menu;

/******************************************************************************/
/* prototypes                                                                 */
/******************************************************************************/

/*** create a menu window ***/
Menu * create_menu( int rows, int cols, int top, int left, void (*updfunc)(void) );
/*** redisplay menu window ***/
void refresh_menu( Menu * m );
/*** add an item to menu ***/
void add_menuitem( Menu * me, int left, int top, char * text, char key, int (*func)(void * data), void * fdata );
/*** delete menu ***/
void del_menu( Menu * me );
/*** show menue ***/
void show_menu( Menu * me );
/*** process menue ***/
int proc_menu( Menu * me, char quitchar );
